The code contained in this folder was used to run the data analysis presented in Section 6.

#### Setup
- Download the data from Wu et al. (2017) (link to data set: https://www.ncbi.nlm.nih.gov/pmc/articles/PMC5667832/bin/pone.0185711.s004.csv) and save it as PWID_Estonia_RDS.xls. This is the data referenced in Section 6 that records the RDS on People Who Inject Drugs (PWID) conducted in the Kohtla-Jarve region in Estonia.

- RDS_Data.Rmd converts PWID_Estonia_RDS.xls into the data components needed for our analysis, e.g., recruitment graph, coupon matrix etc. The output is saved as PWID_RDS_Data.rds.

#### Data analysis
- RDS_App.R generates the indirect inference estimator of population size for the PWID study summarized in PWID_RDS_Data.rds.

#### Bash scripts for parallelization of simulations

- run_analysis_no_aux.sh runs the simulation defined by RDS_App_Sim_No_Aux.R using slurm commands.

- run_analysis_aux.sh runs the simulation defined by RDS_App_Sim_Aux.R using slurm commands.

Both run_analysis_no_aux.sh and run_analysis_aux.sh are run to generate Table 2.

#### Simulation files

- App_True_Graph.rds is the true subgraph between study participants used in the simulations defined by RDS_App_Sim_No_Aux.R and RDS_App_Sim_Aux.R.

- RDS_App_Sim_No_Aux.R simulates RDS study arrival times given the recruitment graph contained in PWID_RDS_Data.rds and the true graph saved in App_True_Graph.rds. It then constructs the indirect inference estimator of the sample subgraph, participant arrival rate, and population size without auxiliary information.

- RDS_App_Sim_Aux.R simulates RDS study arrival times given the recruitment graph contained in PWID_RDS_Data.rds and the true graph saved in App_True_Graph.rds. It then constructs the indirect inference estimator of the sample subgraph, participant arrival rate, and population size with auxiliary information (where the auxiliary information uses the ART status of the study participants in PWID_RDS_Data.rds combined with a Poisson error model described in Section 6).
